;(function () {
  'use strict'

  var toggle = document.querySelector('.page-versions .version-menu-toggle')
  if (!toggle) return

  var selector = document.querySelector('.page-versions')
  var backdrop = document.querySelector('.backdrop')
  var versionMenu = document.querySelector('.version-menu')
  var versions = versionMenu?.querySelectorAll('.version')

  toggle.addEventListener('click', function (e) {
    if (!versions.length) return

    selector.classList.toggle('is-active')
    backdrop.classList.toggle('is-active')
    e.stopPropagation() // trap event
  })

  backdrop.addEventListener('click', function () {
    selector.classList.remove('is-active')
    backdrop.classList.remove('is-active')
  })

  document.documentElement.addEventListener('click', function () {
    selector.classList.remove('is-active')
    backdrop.classList.remove('is-active')
  })
})()
