;(function () {
  'use strict'

  const chatButton = document.querySelector('.sidebar .chat-btn')
  const chat = document.querySelector('.sidebar .chat')
  const chatIcon = document.querySelector('.sidebar .chat-btn svg')
  const chatTextArea = document.getElementById('chat-input')
  const sendButton = document.getElementById('send-btn')
  const chatBody = document.querySelector('.sidebar .chat .chat-body')

  let INIT = false
  let isComposing = false

  const openIconPath = `
    <path stroke-linecap="round" stroke-linejoin="round"
      d="M7.188 10a.312.312 0 1 1-.625 0
      .312.312 0 0 1 .625 0Zm0 0h-.313m3.438 0a.312.312 0
      1 1-.625 0 .312.312 0 0 1 .625 0Zm0 0h-.313m3.437 0a.312.312 0
      1 1-.625 0 .312.312 0 0 1 .625 0Zm0 0h-.312M17.5 10c0 3.797-3.353
      6.875-7.5 6.875a8.735 8.735 0 0 1-2.292-.303 5.368 5.368 0 0 1-3.639
      1.576 5.364 5.364 0 0 1-.428-.059 4.025 4.025 0 0 0 .88-1.818c.081-.409
      -.12-.806-.422-1.098C3.273 13.484 2.5 11.825 2.5 10c0-3.797 3.353-6.875
      7.5-6.875s7.5 3.078 7.5 6.875Z"></path>
  `
  const closeIconPath = `
    <path stroke-linecap="round" stroke-linejoin="round"
      d="M6 18 18 6M6 6l12 12"></path>
  `

  function initializeChat () {
    if (!INIT) {
      const messageItem = document.createElement('pre')
      messageItem.className = 'message ai'
      messageItem.textContent = '뱅크웨어글로벌 소프트웨어 연구소 챗봇입니다. 무엇을 도와드릴까요?'
      chatBody.appendChild(messageItem)
      INIT = true

      // Composition events
      chatTextArea.addEventListener('compositionstart', () => {
        isComposing = true
      })

      chatTextArea.addEventListener('compositionend', () => {
        isComposing = false
      })

      // Keydown event
      chatTextArea.addEventListener('keydown', function (e) {
        if (e.key === 'Enter' && !e.shiftKey && !isComposing) {
          e.preventDefault() // Prevent the default action of Enter (which is to create a new line)
          const { value } = e.target
          if (value.trim() !== '') {
            addMessageToChatBody(value)
            chatTextArea.value = ''
          }
        }
      })

      sendButton.addEventListener('click', () => {
        const message = chatTextArea.value
        addMessageToChatBody(message)
        chatTextArea.value = ''
      })
    }
  }

  chatButton.addEventListener('click', () => {
    chat.classList.toggle('show')

    if (chat.classList.contains('show')) {
      chatIcon.innerHTML = closeIconPath
      chatIcon.setAttribute('fill', 'none')
      chatIcon.setAttribute('stroke', '#fff')
      chatIcon.setAttribute('viewBox', '0 0 24 24')
    } else {
      chatIcon.innerHTML = openIconPath
      chatIcon.setAttribute('fill', '#fff')
      chatIcon.setAttribute('stroke', '#0072ce')
      chatIcon.setAttribute('viewBox', '0 0 20 20')
    }

    if (!INIT) {
      initializeChat()
    }
  })

  function addMessageToChatBody (message) {
    if (message.trim() !== '') {
      const user = document.createElement('pre')
      user.className = 'message user'
      user.textContent = message
      chatBody.appendChild(user)
      chatBody.scrollTop = chatBody.scrollHeight

      const chatLoader = document.createElement('div')
      chatLoader.className = 'chat-loader'
      const loader = document.createElement('div')
      loader.className = 'loader'
      chatLoader.appendChild(loader)
      chatBody.appendChild(chatLoader)
      chatBody.scrollTop = chatBody.scrollHeight

      setTimeout(() => {
        chatBody.removeChild(chatLoader)

        const ai = document.createElement('pre')
        ai.className = 'message ai'
        ai.textContent = '지금은 답해드릴 수 없어요.'
        chatBody.appendChild(ai)
        chatBody.scrollTop = chatBody.scrollHeight
      }, 3000)
    }
  }
})()
