;(function () {
  'use strict'

  var download = document.getElementById('download')

  document.addEventListener('scroll', function () {
    var navbar = document.querySelector('.navbar')

    if (window.scrollY > 0) {
      navbar.classList.add('active')
    } else {
      navbar.classList.remove('active')
    }
  })

  download.addEventListener('click', function () {
    var pathname = window.location.pathname
    var path = pathname.split('/')
    var filename = path[3] ? path[3] === 'swlab-docs' ? 'docs' : `docs-${path[3]}` : ''
    var directory = path[3] && path[4] ? path[3] === 'swlab-docs' ? path[3] : path[4] : ''
    var link = document.createElement('a')

    link.href = `https://swlab.bwg.co.kr/web/dms/download-file?filename=${filename}.zip&directory=${directory}`
    link.click()

    if (link.parentNode) {
      document.body.removeChild(link)
    }
  })
})()
