/* eslint-disable max-len */
;(function () {
  'use strict'

  let isMenuOpen = false
  let isDocumentOpen = false

  const MobileMenuToggle = document.querySelector('.nav-mobile-menu-toggle')
  const documentToggle = document.getElementById('document-toggle')
  const menuIconDefault = `
    <svg stroke="currentColor" fill="#0072ce" stroke-width="0" viewBox="0 0 24 24" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
      <path fill="none" d="M0 0h24v24H0z"></path>
      <path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"></path>
    </svg>
  `
  const menuIconClose = `
    <svg stroke="currentColor" fill="#0072ce" stroke-width="0" viewBox="0 0 24 24" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
      <path fill="none" d="M0 0h24v24H0V0z"></path>
      <path d="M19 6.41 17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z"></path>
    </svg>
  `

  // 화면 크기 감지하여 모바일 화면이 아닐 때 show 클래스 제거
  function checkWindowSize () {
    const menuList = document.querySelector('.navbar-mobile-menu')

    if (window.matchMedia('(min-width: 1023.5px)').matches) {
      menuList.classList.remove('show') // 모바일 화면이 아닐 때 show 제거
      MobileMenuToggle.innerHTML = menuIconDefault // 아이콘 초기화
      isMenuOpen = false
    }
  }

  // 페이지 로드 시 화면 크기 체크
  window.addEventListener('load', checkWindowSize)

  // 화면 크기가 변경될 때마다 체크
  window.addEventListener('resize', checkWindowSize)

  // 메뉴 토글 기능
  MobileMenuToggle.addEventListener('click', function () {
    isMenuOpen = !isMenuOpen
    const menuList = document.querySelector('.navbar-mobile-menu')

    menuList.classList.toggle('show')

    if (isMenuOpen) {
      MobileMenuToggle.innerHTML = menuIconClose
    } else {
      MobileMenuToggle.innerHTML = menuIconDefault
    }
  })

  // Document 토글 기능
  documentToggle.addEventListener('click', function () {
    isDocumentOpen = !isDocumentOpen
    const documentList = document.querySelector('.mobile-product-link')

    documentList.classList.toggle('show')
  })
})()
