;(function () {
  'use strict'

  var captureBody = document.getElementById('capture')
  var captureButton = document.querySelector('.sidebar .capture-btn')
  var captureModal = document.querySelector('.sidebar .capture-modal')
  var closeCaptureModalButton = document.querySelector('.sidebar .capture-modal .close')
  var screenshotImg = document.getElementById('screenshot')
  var saveButton = document.getElementById('save-btn')

  captureButton.addEventListener('click', () => {
    const viewportWidth = window.innerWidth
    const viewportHeight = window.innerHeight
    const scrollX = window.scrollX
    const scrollY = window.scrollY

    html2canvas(captureBody, {
      x: scrollX,
      y: scrollY,
      width: viewportWidth,
      height: viewportHeight,
      scrollX: 0, // reset scrollX for canvas capturing
      scrollY: 0, // reset scrollY for canvas capturing
      scale: 1.3,
      useCORS: true,
    }).then(canvas => {
      screenshotImg.src = canvas.toDataURL()
      captureModal.style.display = 'block'
    })
  })

  closeCaptureModalButton.addEventListener('click', () => {
    captureModal.style.display = 'none'
  })

  saveButton.addEventListener('click', () => {
    var link = document.createElement('a')

    link.href = screenshotImg.src
    link.download = 'screenshot.png'
    link.click()

    document.removeChild(link)
  })
})()
